#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{


	
	

	[TestFixture]
	public class DAL_AntibodyType : BaseTest 
	{

		private DataTable _dtAntibody;
		private DataTable _dtAntibodyParameter;
		int _antibodyTypeId = int.MinValue;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtAntibody = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM AntibodyType JOIN AntibodyAntigen ON AntibodyAntigen.AntibodyTypeId = AntibodyType.AntibodyTypeId JOIN AntigenType ON AntibodyAntigen.AntigenTypeId = AntigenType.AntigenTypeId", true);
				this._antibodyTypeId = (int)_dtAntibody.Rows[0][TABLES.AntibodyType.AntibodyTypeId];

				//Get the antibodyparameter data for the Save call
				this._dtAntibodyParameter = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM AntibodyParameter WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);
				
				this.RefreshData = false;
			}

		}

		[Test]
		public void GetAntibodyType_Int_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetAntibodyType(this._antibodyTypeId);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.RowVersion), TABLES.AntibodyType.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.SortColumn), TABLES.AntibodyType.SortColumn);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyType_Int_Fail()
		{
		}


		[Test]
		public void GetAntibodyTypeLookupList_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetAntibodyTypeLookupList();

            Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.HigherLevelOverrideIndicator), TABLES.AntibodyParameter.HigherLevelOverrideIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.CompatibilityPercentage), TABLES.AntibodyParameter.CompatibilityPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.CanChangeIndicator), TABLES.AntibodyParameter.CanChangeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.RowVersion), TABLES.AntibodyParameter.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyTypeLookupList_Fail()
		{
		}

		[Test]
		public void GetCompleteAntibodyTypeList_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetCompleteAntibodyTypeList();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyReferenceCode), TABLES.AntibodyType.AntibodyReferenceCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.SortColumn), TABLES.AntibodyType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.LastUpdateUser), TABLES.AntibodyType.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.RowVersion), TABLES.AntibodyType.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCompleteAntibodyTypeList_Fail()
		{
		}

		
		[Test]
		public void GetAntibodiesWithoutAntigens_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetAntibodiesWithoutAntigens();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.ClinicallySignificantIndicator), TABLES.AntibodyType.ClinicallySignificantIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.AntibodyParameterGuid), TABLES.AntibodyParameter.AntibodyParameterGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.HigherLevelOverrideIndicator), TABLES.AntibodyParameter.HigherLevelOverrideIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.CompatibilityPercentage), TABLES.AntibodyParameter.CompatibilityPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.CanChangeIndicator), TABLES.AntibodyParameter.CanChangeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.RowVersion), TABLES.AntibodyParameter.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodiesWithoutAntigens_Fail()
		{
		}


		[Test]
		public void GetAntibodyType_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetAntibodyType();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyReferenceCode), TABLES.AntibodyType.AntibodyReferenceCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.SortColumn), TABLES.AntibodyType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.LastUpdateUser), TABLES.AntibodyType.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.RowVersion), TABLES.AntibodyType.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyType_Fail()
		{
		}

		[Test]
		public void GetAntibodyParameterById_Pass()
		{
			DataTable dtAntibody = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 AntibodyTypeId FROM AntibodyParameter", true);
			int antibodyTypeId = (int)dtAntibody.Rows[0][TABLES.AntibodyType.AntibodyTypeId];

			DataTable dtTest = DAL.AntibodyType.GetAntibodyParameterById( antibodyTypeId );

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.AntibodyParameterGuid), TABLES.AntibodyParameter.AntibodyParameterGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.HigherLevelOverrideIndicator), TABLES.AntibodyParameter.HigherLevelOverrideIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.CanChangeIndicator), TABLES.AntibodyParameter.CanChangeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.CompatibilityPercentage), TABLES.AntibodyParameter.CompatibilityPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyParameter.DivisionCode), TABLES.AntibodyParameter.DivisionCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyParameterById_Fail()
		{
		}

		[Test]
		public void GetBloodUnitsWithAntibodyType_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetBloodUnitsWithAntibodyType(this._antibodyTypeId);

			Assert.AreEqual(true, dtTest.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitAntigen.Positive), TABLES.BloodUnitAntigen.Positive);

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodUnitsWithAntibodyType_Fail()
		{
		}

		//Builds a datatable to match spUpdateAntibodyTypes
		private DataTable GetSaveDataTable()
		{
			DataTable dt = new DataTable();

			dt.Columns.Add(TABLES.AntibodyParameter.AntibodyTypeId,typeof(int));
			dt.Columns.Add(TABLES.AntibodyParameter.HigherLevelOverrideIndicator, typeof(bool));
			dt.Columns.Add(TABLES.AntibodyParameter.CompatibilityPercentage, typeof(int));
			dt.Columns.Add(TABLES.AntibodyParameter.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.AntibodyParameter.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.AntibodyParameter.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.AntibodyParameter.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.AntibodyParameter.AntibodyTypeId] = this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.AntibodyTypeId];
			dr[TABLES.AntibodyParameter.HigherLevelOverrideIndicator] = this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.HigherLevelOverrideIndicator];
			dr[TABLES.AntibodyParameter.CompatibilityPercentage] = this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.CompatibilityPercentage];
			dr[TABLES.AntibodyParameter.DivisionCode] = this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.DivisionCode];
			dr[TABLES.AntibodyParameter.RowVersion] = this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.RowVersion];
			dr[TABLES.AntibodyParameter.LastUpdateUser] = this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.LastUpdateUser];
			dr[TABLES.AntibodyParameter.LastUpdateFunctionId] = this._dtAntibodyParameter.Rows[0][TABLES.AntibodyParameter.LastUpdateFunctionId];

			dt.Rows.Add(dr);
			return(dt);
		}
		[Test]
		public void SaveAntibodyTypes_Pass()
		{
			this.RefreshData = true;

			DataTable dtUpdate = this.GetSaveDataTable();
			int tmpValue1 = new Random().Next(100);
			int tmpValue2 = new Random().Next(100);

			dtUpdate.Rows[0][TABLES.AntibodyParameter.HigherLevelOverrideIndicator] = tmpValue1;
			dtUpdate.Rows[0][TABLES.AntibodyParameter.CompatibilityPercentage] = tmpValue2;

			bool retValue = DAL.AntibodyType.SaveAntibodyTypes(dtUpdate);

			Assert.AreEqual(true, retValue, "ReturnValue");
			//Validate the update was successful by checking database?
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveAntibodyTypes_Fail()
		{
			DataTable dtUpdate = this.GetSaveDataTable();
			int tmpValue1 = new Random().Next(100);
			int tmpValue2 = new Random().Next(100);

			dtUpdate.Rows[0][TABLES.AntibodyParameter.HigherLevelOverrideIndicator] = tmpValue1;
			dtUpdate.Rows[0][TABLES.AntibodyParameter.CompatibilityPercentage] = tmpValue2;

			//The wrong row version will cause the exception
			dtUpdate.Rows[0][TABLES.AntibodyParameter.RowVersion] = new byte[8];
			
			DAL.AntibodyType.SaveAntibodyTypes(dtUpdate);
		}


		[Test]
		public void GetAntigenTest_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetAntigenTest();

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenTest.AntigenTestId), TABLES.AntigenTest.AntigenTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenTest.BloodTestTypeId), TABLES.AntigenTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenTest.AntigenTypeId), TABLES.AntigenTest.AntigenTypeId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTest_Fail()
		{
		}

		
		[Test]
		public void GetAntibodiesForAntigenType_Pass()
		{
			DataTable dtTest = DAL.AntibodyType.GetAntibodiesForAntigenType(this._antibodyTypeId);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeId), TABLES.AntibodyType.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeId), TABLES.AntigenType.AntigenTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.AntigenTypeName), TABLES.AntigenType.AntigenTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntigenType.SortColumn), TABLES.AntigenType.SortColumn);
		}

		[Test]
		public void GetAntibodiesForAntigenType_Fail()
		{
			DataTable dtTest = DAL.AntibodyType.GetAntibodiesForAntigenType(int.MinValue);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


	}
}
#endif


